
#include <nds.h>

#include "_const.h"
#include "maindef.h"
#include "_console.h"
#include "_consoleWriteLog.h"

#include "memtool.h"
#undef safemalloc
#define safemalloc safemalloc_chkmem
#include "lang.h"
#include "resume.h"
#include "procstate.h"
#include "shell.h"
#include "splash.h"
#include "strtool.h"
#include "inifile.h"
#include "internaldrivers.h"
#include "cwl.h"
#include "strpcm.h"
#include "sndeff.h"
#include "PlaySE.h"

#include "OSK.h"

#include "unidef.h"

#include "OnSkin.h"
#include "TextEdit.h"

#include "_GlobalTool_DirectPenRead.h"

#include "OSKHW.h"

#include <math.h>

#define double float

#define REG_SQRTCNT			(*(vu16*)(0x040002B0))
#define REG_SQRT_PARAM		(*(vs64*) (0x040002B8))
#define REG_SQRT_PARAM_L	(*(vs32*) (0x040002B8))
#define REG_SQRT_PARAM_H	(*(vs32*) (0x040002BC))
#define REG_SQRT_RESULT		(*(vu32*) (0x040002B4))

#define SQRT_64				1
#define SQRT_32				0
#define SQRT_BUSY			(1<<15)

static inline double _INS_SQRT(double data)
{
  SQRT_CR=SQRT_64;
  while(SQRT_CR&SQRT_BUSY);
  SQRT_PARAM64=(int64)(data*0x1000*64*64);
  while(SQRT_CR&SQRT_BUSY);
  double res=SQRT_RESULT32;
  res/=0x1000;
  return(res);
}

static const u16 OSKHW_InkColor=RGB15(0,0,0)|BIT15;

#include "OSKHW_DrawLine.h"

#include "OSKHW_Model.h"

static bool HWDataLoaded;

static bool MouseDownFlag;
static TModelLine CurLine;
static bool PreviewNow;

static void OSKHW_Screen_Init(void);
static void OSKHW_Screen_Free(void);

void OSKHW_Init(void)
{
  HWDataLoaded=false;
  
  MouseDownFlag=false;
  PreviewNow=false;
  CurLine.PointsCount=0;
  CurLine.pPoints=NULL;
}

void OSKHW_Free(void)
{
  if(HWDataLoaded==false) return;
  HWDataLoaded=false;
  
  UserModel_Free();
  OSKHW_Screen_Free();
  ModelResults_Clear();
  Models_Free();
}

void OSKHW_ModelLoad(void)
{
  if(isStrEqual(OSK_GlobalInfo.pOSK,"HandWrite")==false) return;
  
  if(HWDataLoaded==true) return;
  HWDataLoaded=true;
  
  Models_LoadFromBin();
  UserModel_Init();
  ModelResults_Init();
  
  OSKHW_Screen_Init();
}

static void OSKHW_Clear(void)
{
  OSKHW_Screen_Free();
  ModelResults_Clear();
  Model_Free(&UserModel);
  Model_Free(&UserFitModel);
}

// ---------------------------------------------------------------------------

static u32 DrawCurrentBoxIndex;

static const s32 DBoxCount=2;
static const s32 DBox_Left=0;
static const s32 DBox_Top=24;
static const s32 DBox_Width=128;
static const s32 DBox_Height=128;
static const s32 DBox_SizeX=96;
static const s32 DBox_SizeY=112;

typedef struct {
  s32 x,y;
} TPoint;

static UnicodeChar OSKHW_Screen_StartDraw(s32 mx)
{
  UnicodeChar wc=0;
  
  const s32 SplitLineLeft=DBox_Left+DBox_Width;
  
  u32 idx=0;
  if(SplitLineLeft<=mx) idx=1;
  
  if(DrawCurrentBoxIndex!=(u32)-1){
    if(DrawCurrentBoxIndex!=idx){
      wc=ModelResults_GetChar((u32)-1,UserModel_KogakiFlag);
      OSKHW_Clear();
    }
  }
  
  DrawCurrentBoxIndex=idx;
  
  return(wc);
}

static TPoint OSKHW_Screen_GetCenterPoint(u32 BoxIndex)
{
  s32 Left=DBox_Left+(DBox_Width*BoxIndex);
  s32 Top=DBox_Top;
  
  TPoint res;
  res.x=Left+(DBox_Width/2);
  res.y=Top+(DBox_Height/2);
  
  return(res);
}

static void OSKHW_Screen_DrawBox(CglCanvas *pcan,u32 BoxIndex)
{
  TPoint cp=OSKHW_Screen_GetCenterPoint(BoxIndex);
  
  const s32 HalfSizeX=DBox_SizeX/2;
  const s32 HalfSizeY=DBox_SizeY/2;
  
  u32 x=cp.x-HalfSizeX,y=cp.y-HalfSizeY,sx=DBox_SizeX,sy=DBox_SizeY;
  
  if(DrawCurrentBoxIndex==BoxIndex){
    pcan->SetColor(RGB15(29,31,29)|BIT15);
    pcan->FillBox(x,y,sx,sy);
  }
  
  pcan->SetColor(RGB15(0,0,0)|BIT15);
  pcan->DrawBox(x,y,sx,sy);
  
  pcan->SetColor(RGB15(16,16,16)|BIT15);
  pcan->DrawLine(cp.x-HalfSizeX,cp.y,cp.x+HalfSizeX,cp.y);
  pcan->DrawLine(cp.x,cp.y-HalfSizeY,cp.x,cp.y+HalfSizeY);
}

static void OSKHW_Screen_Draw(void)
{
  CglCanvas *pcan=pScreenMainOverlay->pCanvas;
  
  pcan->FillFull(0);
  
  for(u32 idx=0;idx<DBoxCount;idx++){
    OSKHW_Screen_DrawBox(pcan,idx);
  }
  
  Model_Draw(&UserModel,pcan,0,0,1,OSKHW_InkColor);
  
  ModelResults_DrawPreview(pcan,UserModel_KogakiFlag);
}

static void OSKHW_Screen_Init(void)
{
  DrawCurrentBoxIndex=(u32)-1;
}

static void OSKHW_Screen_Free(void)
{
  DrawCurrentBoxIndex=(u32)-1;
}

// ---------------------------------------------------------------------------

void OSKHW_Draw(void)
{
  if(HWDataLoaded==false) return;
  
  OSKHW_Screen_Draw();
}

// ---------------------------------------------------------------------------

bool OSKHW_KeyPress(u32 keys)
{
  if(HWDataLoaded==false) return(false);
  
  if((keys&KEY_B)!=0){
    if(CurLine.PointsCount!=0){
      if(PreviewNow==true){
        PreviewNow=false;
        CB_KeyPress_FromOSK(WC_BackSpace,true);
      }
      OSKHW_Clear();
      OSKHW_Screen_Draw();
      return(true);
    }
    OSKHW_Clear();
    OSKHW_Screen_Draw();
    PreviewNow=false;
    return(false);
  }
  
  OSKHW_Clear();
  OSKHW_Screen_Draw();
  PreviewNow=false;
  return(false);
}

bool OSKHW_OSKButtonPressCallBack(UnicodeChar wc)
{
  if(HWDataLoaded==false) return(false);
  
  switch(wc){
    case WC_Enter: case WC_Space: break;
    case WC_BackSpace: {
      if(CurLine.PointsCount!=0){
        if(PreviewNow==true){
          PreviewNow=false;
          CB_KeyPress_FromOSK(WC_BackSpace,true);
        }
        OSKHW_Clear();
        OSKHW_Screen_Draw();
        PreviewNow=false;
        return(true);
      }
    } break;
    case WC_Shift:  case WC_CapsLock: break;
    case 0: break;
    default: break;
  }
  
  OSKHW_Clear();
  OSKHW_Screen_Draw();
  PreviewNow=false;
  
  return(false);
}

// ---------------------------------------------------------------------------

static s32 mlx,mly;

static UnicodeChar AutoFixedChar;

bool OSKHW_MouseDown(s32 mx,s32 my)
{
  if(isStrEqual(OSK_GlobalInfo.pOSK,"HandWrite")==false) return(false);
  
  if(HWDataLoaded==false) StopFatalError(0,"Internal error. Model data not loaded.");
  
  if((mx<16)||((ScreenWidth-16)<mx)||(my<16)||((ScreenHeight-32)<my)){
    Sound_Start(WAVFN_Notify);
    return(false);
  }
  
  if(ModelResults_MouseDown(mx,my,&UserFitModel,UserModel_KogakiFlag)==true) return(true);
  
  Sound_Start(WAVFN_MemoPenDown);
  
  MouseDownFlag=true;
  
  mlx=mx;
  mly=my;
  
  AutoFixedChar=OSKHW_Screen_StartDraw(mx);
  
  CurLine.PointsCount=0;
  CurLine.pPoints=(TModelLinePoint*)saferealloc(&MM_SKKOSKHW,CurLine.pPoints,sizeof(TModelLinePoint)*(CurLine.PointsCount+1));
  CurLine.pPoints[CurLine.PointsCount].x=mx;
  CurLine.pPoints[CurLine.PointsCount].y=my;
  CurLine.PointsCount++;
  
  return(true);
}

void OSKHW_MouseMove(s32 mx,s32 my)
{
  if(ModelResults_MouseMove(mx,my)==true) return;
  
  if(MouseDownFlag==false) return;
  
  {
    s32 tx=mx-CurLine.pPoints[CurLine.PointsCount-1].x;
    s32 ty=my-CurLine.pPoints[CurLine.PointsCount-1].y;
    double len=_INS_SQRT(double((tx*tx)+(ty*ty)));
    if(len<2) return;
    if(50<=len) return;
  }

  {
    CurLine.pPoints=(TModelLinePoint*)saferealloc(&MM_SKKOSKHW,CurLine.pPoints,sizeof(TModelLinePoint)*(CurLine.PointsCount+1));
    CurLine.pPoints[CurLine.PointsCount].x=mx;
    CurLine.pPoints[CurLine.PointsCount].y=my;
    CurLine.PointsCount++;
  }
  
  CglCanvas *pcan=pScreenMainOverlay->pCanvas;
  DrawLine(pcan,mlx,mly,mx,my,OSKHW_InkColor);
  
  mlx=mx; mly=my;
}

void OSKHW_MouseUp(s32 mx,s32 my)
{
  {
    UnicodeChar wc;
    if(ModelResults_MouseUp(mx,my,&wc)==true){
      if(wc!=0){
        PlaySE_Long();
        if(PreviewNow==true){
          PreviewNow=false;
          CB_KeyPress_FromOSK(WC_BackSpace,false);
        }
        CB_KeyPress_FromOSK(wc,true);
        OSKHW_Clear();
        ModelLine_Free(&CurLine);
      }
      return;
    }
  }
  
  if(MouseDownFlag==false) return;
  MouseDownFlag=false;
  
  if(PreviewNow==true){
    PreviewNow=false;
    CB_KeyPress_FromOSK(WC_BackSpace,false);
  }
  
  if(AutoFixedChar!=0){
    CB_KeyPress_FromOSK(AutoFixedChar,true);
    AutoFixedChar=0;
  }
  
  if(CurLine.PointsCount==0) StopFatalError(0,"Internal error.");
  
  if(CurLine.PointsCount==1) return; // ignore 1 point.
  
  ModelLine_DirectToRelay(&CurLine);
  ModelLine_CreateLength(&CurLine);
  
  _consolePrintf("TotalLen= %f.\n",CurLine.TotalLen);
  
  bool EraseFlag=false;
  if(500<=CurLine.TotalLen) EraseFlag=true;
  if(30<=CurLine.TotalLen){
    bool ignore=false;
    double y=0;
    for(u32 pidx=CurLine.PointsCount/4;pidx<CurLine.PointsCount;pidx++){ // 擪1/4͎̂Ă
      double mx=CurLine.pPoints[pidx].x,my=CurLine.pPoints[pidx].y;
      if(0.01<mx){
        ignore=true;
        break;
      }
      y+=my;
    }
    if(ignore==false){
      _consolePrintf("Erase check: ydiff= %f.\n",y);
      if((-8<y)&&(y<16)) EraseFlag=true;
    }
  }
  if(EraseFlag==true){
    if(UserModel.LinesCount!=0){
      Sound_Start(WAVFN_MemoErase);
      }else{
      CB_KeyPress_FromOSK(WC_BackSpace,true);
    }
    OSKHW_Clear();
    ModelLine_Free(&CurLine);
    return;
  }
  
  PrfStart();
  
  UserModel.pLines=(TModelLine*)saferealloc(&MM_SKKOSKHW,UserModel.pLines,sizeof(TModelLine)*(UserModel.LinesCount+1));
  ModelLine_ProcDiv32(&CurLine,&UserModel.pLines[UserModel.LinesCount]);
  UserModel.LinesCount++;
  ModelLine_Free(&CurLine);
  
  Model_Free(&UserFitModel);
  ModelResults_Clear();
  
  if(UserModel_Fit()==false){
    Model_Free(&UserFitModel);
    ModelResults_Clear();
    return;
  }
  
  if(UserModel_Match()==false){
    Model_Free(&UserFitModel);
    ModelResults_Clear();
    return;
  }

  ModelResults_Sort();
  
  if(UserModel_KogakiFlag==true) _consolePrintf("Detected Kogaki-flag.\n");
  
  if(ModelResultsCount!=0){
    UnicodeChar wc=ModelResults_GetChar(0,UserModel_KogakiFlag);
    PreviewNow=true;
    CB_KeyPress_FromOSK(wc,true);
  }
}

// ---------------------------------------------------------------------------

#undef double
